/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: ProfibusMPI_RFC1006_Functionlist.h $
   Last Modification:
    $Author: Alexanderw $
    $Modtime: 2.11.07 14:44 $
    $Revision: 1 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    ProfibusMPI_ RFC1006
    Task function list for configuration file

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------

**************************************************************************************/
/**
 * @file ProfibusMPI_RFC1006_Functionlist.h
 * @brief ProfibusMPI_ RFC1006 - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_ProfibusMPI_RFC1006</code>
 * of task.
 */
#ifndef __PROFIBUSMPI_RFC1006_FUNCTIONLIST_H
#define __PROFIBUSMPI_RFC1006_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_ProfibusMPI_RFC1006
(
 TLR_VOID FAR* pvRsc
);

TLR_VOID
TaskEnter_ProfibusMPI_RFC1006
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define PROFIBUSMPI_RFC1006_STARTUP_PARAM_VERSION (1)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct PROFIBUSMPI_RFC1006_STARTUPPARAMETER_Ttag  PROFIBUSMPI_RFC1006_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct PROFIBUSMPI_RFC1006_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_UINT32    ulTaskIdentifier;
  TLR_UINT32    ulParamVersion;

  /** A dummy */
  TLR_UINT32  ulDummy;
};

/** @} */


/*************************************************************************************/
#endif /* #ifndef __PROFIBUSMPI_RFC1006_FUNCTIONLIST_H */
